import requests


class StaffApi(object):
    API_URL = "https://staff-api.yandex-team.ru/v3"

    def __init__(self, token):
        self.session = requests.Session()
        self.session.headers.update({
            'Authorization': 'OAuth {}'.format(token),
        })

    def staff_group_id_by_slug(self, slug):
        url = (
            self.API_URL + '/groups'
            '?_one=1'
            '&_fields=id'
            '&url={}'.format(slug)
        )

        with self.session.get(url, timeout=10) as resp:
            resp.raise_for_status()
            data = resp.json()
            if 'id' in data:
                return data['id']
            else:
                raise Exception("Failed to resolve staff group {!r}: {}".format(
                    slug,
                    data.get('error_message', 'unknown error'),
                ))
