from collections import defaultdict
import re


def fill_patterns(v, graph, used, variables, context, bad_keys):
    if v not in graph:
        return
    used[v] = True
    for to in graph[v]:
        if not used[to]:
            fill_patterns(to, graph, used, variables, context, bad_keys)

    try:
        variables[v] = variables[v] % context
    except KeyError as e:
        bad_keys.append(e.args[0])

    context[v] = variables[v]  # enrich context passed by reference


def process_graph(graph, variables, context):
    used = defaultdict(bool)
    in_edge = defaultdict(int)
    bad_keys = []
    for v in graph:
        for to in v:
            in_edge[to] += 1
    for v in graph:
        if not used[v] and in_edge[v] == 0:
            fill_patterns(v, graph, used, variables, context, bad_keys)
    return bad_keys


def resolve(variables, context):
    variables = variables.copy()
    context = context.copy()
    context.update(variables)
    graph = defaultdict(list)

    for key, value in variables.iteritems():
        patterns = re.findall(r"%\(.*?\)s", value)
        for pattern in patterns:
            graph[key].append(pattern[2:-2])

    bad_keys = process_graph(graph, variables, context)
    return variables, bad_keys
