import io
import http
import http.server
import shutil
import socket

from library.python import resource


class Handler(http.server.BaseHTTPRequestHandler):
    def do_GET(self):
        data = resource.find('out.txt')
        self.send_response(http.HTTPStatus.OK)
        self.send_header('Content-Type', 'text/plain; charset=utf-8')
        self.send_header('Content-Length', str(len(data)))
        self.end_headers()
        with io.BytesIO(data) as f:
            shutil.copyfileobj(f, self.wfile)


class Server(http.server.ThreadingHTTPServer):
    address_family = socket.AF_INET6


def main():
    server_address = ('::', 8080)
    httpd = Server(server_address, Handler)
    httpd.serve_forever()
