package main

import (
	"a.yandex-team.ru/infra/deploy_doctor/cmd/exporter"
	"a.yandex-team.ru/infra/deploy_doctor/cmd/server"
	"fmt"
	"os"

	"github.com/spf13/cobra"
)

var (
	cfgFile string

	rootCmd = &cobra.Command{
		Use:   "infra doctor",
		Short: "Manage deploy/nanny default alerts",
	}
)

func init() {
	rootCmd.PersistentFlags().StringVar(&cfgFile, "config", "", "")

	rootCmd.AddCommand(exporter.StartExport())
	rootCmd.AddCommand(server.StartServer())

}

func main() {
	if err := rootCmd.Execute(); err != nil {
		fmt.Fprintln(os.Stderr, err)
		os.Exit(1)
	}
}
