from gevent import monkey

monkey.patch_all()

from grpc.experimental.gevent import init_gevent

init_gevent()

try:
    import argparse
    from infra.swatlib import cmdutil
    from infra.deploy_export_stats.src.main import Application
    from functools import partial
except KeyboardInterrupt:
    # don't bother user with python stack trace
    # if interrupted (by Ctrl+C) during imports
    raise SystemExit(1)


def init_arg_parser():
    p = argparse.ArgumentParser(description=Application.name)
    p.add_argument('-c', '--cfg',
                   default=None,
                   action='store', help='path to service cfg file')
    p.add_argument('-Y', '--yp-token',
                   default=None,
                   dest='yp_token',
                   help='Yp Token')
    p.add_argument('-N', '--nanny-token',
                   default=None,
                   dest='nanny_token',
                   help='Nanny Token')
    p.add_argument('-Q', '--qloud-token',
                   default=None,
                   dest='qloud_token',
                   help='Qloud Token')
    # --console is used to dump logs during debugging with IDE
    # when stdout isn't terminal but we don't want to log to file
    p.add_argument('--console',
                   default=False,
                   action='store_true',
                   help='redirect log to stdout (overrides config)')
    p.add_argument('-d', '--debug',
                   default=False,
                   action='store_true',
                   help='do NOT daemonize, do NOT change working dir')
    return p


def main():
    arg_parser = init_arg_parser()

    args = arg_parser.parse_args()
    _Application = partial(Application,
                           yp_token=args.yp_token,
                           nanny_token=args.nanny_token,
                           qloud_token=args.qloud_token
                           )
    _Application.name = Application.name

    cmdutil.main(arg_parser, _Application)


if __name__ == '__main__':
    main()
