#include <infra/deploy_monitoring_controller/libs/daemon/main.h>

#include <infra/libs/logger/log_printer.h>
#include <infra/libs/sensors/sensor_registry.h>

#include <library/cpp/getopt/modchooser.h>

#include <util/generic/yexception.h>
#include <util/stream/output.h>

int main(int argc, const char* argv[]) {
    NInfra::SetSensorRegistryCommonGroup({"deploy_monitoring_controller"});

    TModChooser modChooser;

    modChooser.AddMode(
        "run",
        NInfra::NDeployMonitoringController::RunDaemon,
        "Run DeployMonitoringController daemon."
    );

    modChooser.AddMode(
        "print_log",
        NInfra::PrintEventLog,
        "Print DeployMonitoringController log."
    );

    try {
        return modChooser.Run(argc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return -1;
    }

    return 0;
}
