#include "multi_cluster_replica_set_manager.h"
#include "support_functions.h"

namespace NInfra::NDeployMonitoringController {

NController::ISingleClusterObjectManager::TSelectArgument TMultiClusterReplicaSetManagerFactory::GetSelectArgument(const TVector<TVector<NController::TSelectorResultPtr>>& /* aggregateResults */, NInfra::TLogFramePtr) const {
    return {
        NYP::NClient::NApi::NProto::OT_MULTI_CLUSTER_REPLICA_SET
        , {
            "/meta/id"
            , "/spec/revision"
            , "/status/revision"
            , "/status/ready"

            // for lagCorrectionFactor
            , "/spec/clusters"
            , "/spec/deployment_strategy/max_unavailable"
        } /* selector */
        , R"([/labels/created_by] = "stage_controller" or [/labels/created_by] = "env_controller")" /* filter */
        , NSupport::YpSelectOptionsWithTimestamps() /* options */
    };
}

TVector<TUnistatManager::TObject> TMultiClusterReplicaSetManagerFactory::GetObjects(const NController::TSelectorResultPtr& selectorResultPtr) const {
    NYP::NClient::TMultiClusterReplicaSet multiClusterReplicaSet;
    ui64 specRevision;
    ui64 statusRevision;
    ui64 maxUnavailable;
    selectorResultPtr->Fill(
        multiClusterReplicaSet.MutableMeta()->mutable_id()
        , &specRevision
        , &statusRevision
        , multiClusterReplicaSet.MutableStatus()->mutable_ready()
        , multiClusterReplicaSet.MutableSpec()->mutable_clusters()
        , &maxUnavailable
    );
    multiClusterReplicaSet.MutableSpec()->set_revision(specRevision);
    multiClusterReplicaSet.MutableStatus()->set_revision(statusRevision);

    ui64 replicaCount = 0;
    for (const auto& cluster : multiClusterReplicaSet.Spec().clusters()) {
        replicaCount += cluster.spec().replica_count();
    }

    double lagCorrectionFactor = 1.0;
    if (replicaCount > 0 && maxUnavailable <= replicaCount) {
        lagCorrectionFactor = (double)maxUnavailable / replicaCount;
    }

    return {
        TUnistatManager::TObject(
            multiClusterReplicaSet.Meta().id()
            , multiClusterReplicaSet.Spec().revision()
            , NSupport::YpTimestampToInstant(selectorResultPtr->Values().timestamps(1)) // spec revision timestamp
            , multiClusterReplicaSet.Status().revision()
            , multiClusterReplicaSet.Status().ready().status() == NYP::NClient::NApi::NProto::EConditionStatus::CS_TRUE
            , NSupport::ProtoTimestampToInstant(multiClusterReplicaSet.Status().ready().last_transition_time())
            , lagCorrectionFactor
        )
    };
}

} // namespace NInfra::NDeployMonitoringController
