#include "pod_manager.h"
#include "support_functions.h"

#include <util/string/builder.h>

namespace NInfra::NDeployMonitoringController {

NController::ISingleClusterObjectManager::TSelectArgument TPodManagerFactory::GetSelectArgument(const TVector<TVector<NController::TSelectorResultPtr>>& /* aggregateResults */, NInfra::TLogFramePtr) const {
    return {
        NYP::NClient::NApi::NProto::OT_POD
        , {
            "/meta/id"
            , "/meta/pod_set_id"
            , "/spec/pod_agent_payload/spec/revision"
            , "/status/agent/pod_agent_payload/status/revision"
            , "/status/agent/pod_agent_payload/status/ready"
        } /* selector */
        , R"([/labels/deploy_engine] = "RSC" or [/labels/deploy_engine] = "MCRSC")" /* filter */
        , NSupport::YpSelectOptionsWithTimestamps() /* options */
    };
}

TVector<TUnistatManager::TObject> TPodManagerFactory::GetObjects(const NController::TSelectorResultPtr& selectorResultPtr) const {
    NYP::NClient::TPod pod;
    ui64 specRevision;
    ui64 statusRevision;
    selectorResultPtr->Fill(
        pod.MutableMeta()->mutable_id()
        , pod.MutableMeta()->mutable_pod_set_id()
        , &specRevision
        , &statusRevision
        , pod.MutableStatus()->mutable_agent()->mutable_pod_agent_payload()->mutable_status()->mutable_ready()
    );
    pod.MutableSpec()->mutable_pod_agent_payload()->mutable_spec()->set_revision(specRevision);
    pod.MutableStatus()->mutable_agent()->mutable_pod_agent_payload()->mutable_status()->set_revision(statusRevision);

    return {
        TUnistatManager::TObject(
            TStringBuilder() << pod.Meta().pod_set_id() << "." << pod.Meta().id()
            , pod.Spec().pod_agent_payload().spec().revision()
            , NSupport::YpTimestampToInstant(selectorResultPtr->Values().timestamps(2)) // spec revision timestamp
            , pod.Status().agent().pod_agent_payload().status().revision()
            , pod.Status().agent().pod_agent_payload().status().ready().status() == NInfra::NPodAgent::API::EConditionStatus::EConditionStatus_TRUE
            , NSupport::ProtoTimestampToInstant(pod.Status().agent().pod_agent_payload().status().ready().last_transition_time())
            , 1.0 // lagCorrectionFactor
        )
    };
}

} // namespace NInfra::NDeployMonitoringController
