#pragma once

#include "unistat_manager_base.h"

namespace NInfra::NDeployMonitoringController {

class TPodManagerFactory : public TUnistatManagerFactoryBase {
public:
    TPodManagerFactory(
        const TUnistatConfig& unistatConfig
        , const TYtObjectStorageConfig& ytStorageConfig
        , NController::TShardPtr shard
    )
        : TUnistatManagerFactoryBase(
            "pod_manager_factory"
            , NLogEvent::TDeployObjectLag_EDeployObjectType_OT_POD
            , "pod_lag_sec"
            , unistatConfig
            , ytStorageConfig
            , shard
        )
    {}

protected:
    virtual NController::ISingleClusterObjectManager::TSelectArgument GetSelectArgument(const TVector<TVector<NController::TSelectorResultPtr>>& /* aggregateResults */ = {}, NInfra::TLogFramePtr = {}) const override final;
    virtual TVector<TUnistatManager::TObject> GetObjects(const NController::TSelectorResultPtr& selectorResultPtr) const override final;
};

} // namespace NInfra::NDeployMonitoringController
