#include "replica_set_manager.h"
#include "support_functions.h"

namespace NInfra::NDeployMonitoringController {

NController::ISingleClusterObjectManager::TSelectArgument TReplicaSetManagerFactory::GetSelectArgument(const TVector<TVector<NController::TSelectorResultPtr>>& /* aggregateResults */, NInfra::TLogFramePtr) const {
    return {
        NYP::NClient::NApi::NProto::OT_REPLICA_SET
        , {
            "/meta/id"
            , "/spec/revision_id"
            , "/status/revision_id"
            , "/status/ready_condition"

            // for lagCorrectionFactor
            , "/spec/replica_count"
            , "/spec/deployment_strategy/max_unavailable"
        } /* selector */
        , R"([/labels/created_by] = "stage_controller" or [/labels/created_by] = "env_controller")" /* filter */
        , NSupport::YpSelectOptionsWithTimestamps() /* options */
    };
}

TVector<TUnistatManager::TObject> TReplicaSetManagerFactory::GetObjects(const NController::TSelectorResultPtr& selectorResultPtr) const {
    NYP::NClient::TReplicaSet replicaSet;
    ui64 replicaCount;
    ui64 maxUnavailable;
    selectorResultPtr->Fill(
        replicaSet.MutableMeta()->mutable_id()
        , replicaSet.MutableSpec()->mutable_revision_id()
        , replicaSet.MutableStatus()->mutable_revision_id()
        , replicaSet.MutableStatus()->mutable_ready_condition()
        , &replicaCount
        , &maxUnavailable
    );

    double lagCorrectionFactor = 1.0;
    if (replicaCount > 0 && maxUnavailable <= replicaCount) {
        lagCorrectionFactor = (double)maxUnavailable / replicaCount;
    }

    return {
        TUnistatManager::TObject(
            replicaSet.Meta().id()
            , FromString<ui64>(replicaSet.Spec().revision_id())
            , NSupport::YpTimestampToInstant(selectorResultPtr->Values().timestamps(1)) // spec revision timestamp
            , FromString<ui64>(replicaSet.Status().revision_id())
            , replicaSet.Status().ready_condition().status() == NYP::NClient::NApi::NProto::EConditionStatus::CS_TRUE
            , NSupport::ProtoTimestampToInstant(replicaSet.Status().ready_condition().last_transition_time())
            , lagCorrectionFactor
        )
    };
}

} // namespace NInfra::NDeployMonitoringController
