#pragma once

#include "unistat_manager_base.h"

namespace NInfra::NDeployMonitoringController {

class TReplicaSetManagerFactory : public TUnistatManagerFactoryBase {
public:
    TReplicaSetManagerFactory(
        const TUnistatConfig& unistatConfig
        , const TYtObjectStorageConfig& ytStorageConfig
        , NController::TShardPtr shard
    )
        : TUnistatManagerFactoryBase(
            "replica_set_manager_factory"
            , NLogEvent::TDeployObjectLag_EDeployObjectType_OT_REPLICA_SET
            , "replica_set_lag_sec"
            , unistatConfig
            , ytStorageConfig
            , shard
        )
    {}

protected:
    virtual NController::ISingleClusterObjectManager::TSelectArgument GetSelectArgument(const TVector<TVector<NController::TSelectorResultPtr>>& /* aggregateResults */ = {}, NInfra::TLogFramePtr = {}) const override final;
    virtual TVector<TUnistatManager::TObject> GetObjects(const NController::TSelectorResultPtr& selectorResultPtr) const override final;
};

} // namespace NInfra::NDeployMonitoringController
