#include "stage_manager.h"
#include "support_functions.h"

#include <util/string/builder.h>

namespace NInfra::NDeployMonitoringController {

NController::ISingleClusterObjectManager::TSelectArgument TStageManagerFactory::GetSelectArgument(const TVector<TVector<NController::TSelectorResultPtr>>& /* aggregateResults */, NInfra::TLogFramePtr) const {
    return {
        NYP::NClient::NApi::NProto::OT_STAGE
        , {
            "/meta/id"
            , "/spec" // TODO(chegoryu) download only deploy_units
            , "/status" // TODO(chegoryu) download only deploy_units
        } /* selector */
        , "" /* filter */
        , NSupport::YpSelectOptionsWithTimestamps() /* options */
    };
}

TVector<TUnistatManager::TObject> TStageManagerFactory::GetObjects(const NController::TSelectorResultPtr& selectorResultPtr) const {
    NYP::NClient::TStage stage;
    selectorResultPtr->Fill(
        stage.MutableMeta()->mutable_id()
        , stage.MutableSpec()
        , stage.MutableStatus()
    );

    TVector<TUnistatManager::TObject> objects;
    objects.reserve(stage.Spec().deploy_units().size());
    for (const auto& [deployUnitId, deployUnitSpec] : stage.Spec().deploy_units()) {
        const TString objectId = TStringBuilder() << stage.Meta().id() << "." << deployUnitId;
        const auto statusPtr = stage.Status().deploy_units().find(deployUnitId);

        if (statusPtr != stage.Status().deploy_units().end()) {
            const auto& status = statusPtr->second;
            objects.emplace_back(
                objectId
                , deployUnitSpec.revision()
                , NSupport::YpTimestampToInstant(selectorResultPtr->Values().timestamps(1)) // spec timestamp
                , status.target_revision()
                , status.ready().status() == NYP::NClient::NApi::NProto::EConditionStatus::CS_TRUE
                , NSupport::ProtoTimestampToInstant(status.ready().last_transition_time())
                , 1.0 // lagCorrectionFactor
            );
        } else {
            objects.emplace_back(
                objectId
                , deployUnitSpec.revision()
                , NSupport::YpTimestampToInstant(selectorResultPtr->Values().timestamps(1)) // spec timestamp
                , 0 // Fake status revision
                , false // No status => ready = false
                , TInstant::Zero() // No status => readyTimestamp = 0
                , 1.0 // lagCorrectionFactor
            );
        }
    }

    return objects;
}

} // namespace NInfra::NDeployMonitoringController
