#pragma once

#include "unistat_manager_base.h"

namespace NInfra::NDeployMonitoringController {

class TStageManagerFactory : public TUnistatManagerFactoryBase {
public:
    TStageManagerFactory(
        const TUnistatConfig& unistatConfig
        , const TYtObjectStorageConfig& ytStorageConfig
        , NController::TShardPtr shard
    )
        : TUnistatManagerFactoryBase(
            "stage_manager_factory"
            , NLogEvent::TDeployObjectLag_EDeployObjectType_OT_DEPLOY_UNIT
            , "stage_lag_sec"
            , unistatConfig
            , ytStorageConfig
            , shard
        )
    {}

protected:
    virtual NController::ISingleClusterObjectManager::TSelectArgument GetSelectArgument(const TVector<TVector<NController::TSelectorResultPtr>>& /* aggregateResults */ = {}, NInfra::TLogFramePtr = {}) const override final;
    virtual TVector<TUnistatManager::TObject> GetObjects(const NController::TSelectorResultPtr& selectorResultPtr) const override final;
};

} // namespace NInfra::NDeployMonitoringController
