#include "support_functions.h"

namespace NInfra::NDeployMonitoringController::NSupport {

NYP::NClient::TSelectObjectsOptions YpSelectOptionsWithTimestamps() {
    NYP::NClient::TSelectObjectsOptions options;
    options.SetFetchTimestamps(true);

    return options;
}

TInstant ProtoTimestampToInstant(const google::protobuf::Timestamp& timestamp) {
    return TInstant::MicroSeconds(timestamp.seconds() * (ui64)1000000 + timestamp.nanos() / 1000);
}

TInstant YpTimestampToInstant(const ui64 ypTimestamp) {
    return TInstant::Seconds(ypTimestamp >> 30);
}

} // namespace NInfra::NDeployMonitoringController::NSupport
