#include "main.h"

#include <infra/deploy_monitoring_controller/libs/config/config.pb.h>

#include <infra/deploy_monitoring_controller/libs/controller/multi_cluster_replica_set_manager.h>
#include <infra/deploy_monitoring_controller/libs/controller/pod_manager.h>
#include <infra/deploy_monitoring_controller/libs/controller/replica_set_manager.h>
#include <infra/deploy_monitoring_controller/libs/controller/stage_manager.h>

#include <infra/deploy_monitoring_controller/libs/service/service.h>

#include <infra/libs/controller/daemon/main.h>

namespace NInfra::NDeployMonitoringController {

int RunDaemon(int argc, const char* argv[]) {
    const TConfig config = NProtoConfig::GetOpt<TConfig>(argc, argv, "/proto_config/config.json");
    const NUpdatableProtoConfig::TConfigHolderConfig& updatableConfigOpts = config.GetController().GetUpdatableConfigOptions();

    NUpdatableProtoConfig::TConfigHolderPtr<TConfig> configHolder = NUpdatableProtoConfig::CreateConfigHolder(config, updatableConfigOpts);

    NInfra::NController::TSharding shardsFactory(config.GetController().GetLeadingInvader());
 
    TVector<NController::TSingleClusterObjectManagersFactoryPtr> objectFactories({
        new TMultiClusterReplicaSetManagerFactory(
            config.GetUnistat()
            , config.GetYtObjectStorage()
            , shardsFactory.GetShard(0)
        ),
        new TPodManagerFactory(
            config.GetUnistat()
            , config.GetYtObjectStorage()
            , shardsFactory.GetShard(0)
        ),
        new TReplicaSetManagerFactory(
            config.GetUnistat()
            , config.GetYtObjectStorage()
            , shardsFactory.GetShard(0)
        ),
        new TStageManagerFactory(
            config.GetUnistat()
            , config.GetYtObjectStorage()
            , shardsFactory.GetShard(0)
        )
    });

    return NController::RunDaemon<TService>(
        configHolder->Accessor<NController::TControllerConfig>("Controller")
        , std::move(objectFactories)
    );
}

} // namespace NInfra::NDeployMonitoringController
