#pragma once

#include <util/datetime/base.h>
#include <util/generic/ptr.h>
#include <util/generic/vector.h>

namespace NInfra::NDeployMonitoringController {

class IObjectStorage;
using TObjectStoragePtr = TAtomicSharedPtr<IObjectStorage>;

class IObjectStorage {
public:
    struct TObject {
        TObject(
            const TString& id
            , ui64 lastReadyRevision
            , TInstant lastReadyAchivedTimestamp
            , ui64 currentRevision
            , TInstant currentRevisionSpecTimestamp
        )
            : Id_(id)
            , LastReadyRevision_(lastReadyRevision)
            , LastReadyAchivedTimestamp_(lastReadyAchivedTimestamp)
            , CurrentRevision_(currentRevision)
            , CurrentRevisionSpecTimestamp_(currentRevisionSpecTimestamp)
        {}

        bool operator!=(const TObject& other) const {
            return Id_ != other.Id_
                || LastReadyRevision_ != other.LastReadyRevision_
                || LastReadyAchivedTimestamp_ != other.LastReadyAchivedTimestamp_
                || CurrentRevision_ != other.CurrentRevision_
                || CurrentRevisionSpecTimestamp_ != other.CurrentRevisionSpecTimestamp_
            ;
        }

        const TString Id_;

        const ui64 LastReadyRevision_;
        const TInstant LastReadyAchivedTimestamp_;

        const ui64 CurrentRevision_;
        const TInstant CurrentRevisionSpecTimestamp_;
    };

public:
    virtual ~IObjectStorage() = default;

    virtual TVector<TObject> GetObjectList() const = 0;
    virtual void UpdateObjectList(const TVector<TObject>& objects) = 0;
};

} // namespace NInfra::NDeployMonitoringController
