#pragma once

#include "object_storage.h"

#include <infra/deploy_monitoring_controller/libs/config/config.pb.h>

#include <mapreduce/yt/interface/client.h>

namespace NInfra::NDeployMonitoringController {

class TYtObjectStorage : public IObjectStorage {
public:
    TYtObjectStorage(
        const TYtObjectStorageConfig& config
        , const TString& tableName
    )
        : TablePath_(config.GetTableFolderPath() + "/" + tableName)
    {
        if (!config.GetToken().Empty()) {
            Client_ = NYT::CreateClient(
                config.GetProxy()
                , NYT::TCreateClientOptions().Token(config.GetToken())
            );
        } else {
            Client_ = NYT::CreateClient(config.GetProxy());
        }

        EnsureTableMounted();
    }

    virtual TVector<TObject> GetObjectList() const override final;
    virtual void UpdateObjectList(const TVector<TObject>& objects) override final;

private:
    // Create table if not exist
    // Mount table if not mounted
    // Otherwise do nothing
    void EnsureTableMounted();

    void InsertObject(const TObject& object);
    void RemoveObject(const TObject& object);

private:
    const TString TablePath_;
    NYT::IClientPtr Client_;

    static inline const TString ID_KEY = "id";
    static inline const TString LAST_READY_REVISION_KEY = "last_ready_revision";
    static inline const TString LAST_READY_ACHIVED_TIMESTAMP_KEY = "last_ready_achived_timestamp";
    static inline const TString CURRENT_REVISION_KEY = "current_revision";
    static inline const TString CURRENT_REVISION_SPEC_TIMESTAMP_KEY = "current_revision_spec_timestamp";
    static inline const NYT::TTableSchema SCHEMA = NYT::TTableSchema()
        .AddColumn(ID_KEY, NYT::EValueType::VT_STRING, NYT::ESortOrder::SO_ASCENDING)
        .AddColumn(LAST_READY_REVISION_KEY, NYT::EValueType::VT_UINT64)
        .AddColumn(LAST_READY_ACHIVED_TIMESTAMP_KEY, NYT::EValueType::VT_UINT64)
        .AddColumn(CURRENT_REVISION_KEY, NYT::EValueType::VT_UINT64)
        .AddColumn(CURRENT_REVISION_SPEC_TIMESTAMP_KEY, NYT::EValueType::VT_UINT64)
    ;
};

} // namespace NInfra::NDeployMonitoringController
