#include "service.h"

#include <infra/libs/service_iface/str_iface.h>

#include <infra/deploy_monitoring_controller/libs/unistat/unistat.h>

namespace NInfra::NDeployMonitoringController {

TRequestRouterPtr CreatePrivateRouter(TService& service) {
    auto router = MakeSimpleShared<TRequestRouter<TService>>(service);

    (*router)
        .Add<TEmptyRequest<NController::TReqPing>, TRawDataReply<NController::TRspPing>>("/ping", "Pong.", &TService::Ping)
        .Add<TEmptyRequest<NController::TReqReopenLog>, TEmptyReply<NController::TRspReopenLog>>("/reopen_log", "Reopen eventlog.", &TService::ReopenLog)
        .Add<TEmptyRequest<NController::TReqSensors>, TRawDataReply<NController::TRspSensors>>("/sensors", "Show controller sensors.", &TService::Sensors)
        .Add<TEmptyRequest<NController::TReqShutdown>, TEmptyReply<NController::TRspShutdown>>("/shutdown", "Shutdown controller.", &TService::Shutdown)
        .Add<TEmptyRequest<TReqUnistat>, TRawDataReply<TRspUnistat>>("/unistat", "Show unistat sensors.", &TService::Unistat);

    return router;
}

TService::TService(const THttpServiceConfig& cfg, TLogger& logger, NController::TControllerLoop& controller)
    : NController::TService(cfg, logger, controller, CreatePrivateRouter(*this))
{}

void TService::Unistat(TRequestPtr<TReqUnistat>, TReplyPtr<TRspUnistat> reply) {
    TRspUnistat result;
    *result.MutableData() = THistogramUnistat::Instance().DumpHistograms();
    reply->Set(result);
}

} // namespace NInfra::NDeployMonitoringController
