#pragma once

#include <infra/deploy_monitoring_controller/libs/config/config.pb.h>

#include <infra/deploy_monitoring_controller/libs/controller/multi_cluster_replica_set_manager.h>
#include <infra/deploy_monitoring_controller/libs/controller/pod_manager.h>
#include <infra/deploy_monitoring_controller/libs/controller/replica_set_manager.h>
#include <infra/deploy_monitoring_controller/libs/controller/stage_manager.h>

#include <infra/libs/controller/standalone_controller/standalone_controller.h>

#include <library/cpp/proto_config/config.h>

namespace NInfra::NDeployMonitoringController {

TVector<NController::TSingleClusterObjectManagersFactoryPtr> CreateFactories(TStringBuf configJson) {
    auto config = NProtoConfig::ParseConfigFromJson<TConfig>(configJson);

    NInfra::NController::TSharding shardsFactory(config.GetController().GetLeadingInvader());
    return {
        new TMultiClusterReplicaSetManagerFactory(
            config.GetUnistat()
            , config.GetYtObjectStorage()
            , shardsFactory.GetShard(0)
        )
        , new TPodManagerFactory(
            config.GetUnistat()
            , config.GetYtObjectStorage()
            , shardsFactory.GetShard(0)
        )
        , new TReplicaSetManagerFactory(
            config.GetUnistat()
            , config.GetYtObjectStorage()
            , shardsFactory.GetShard(0)
        )
        , new TStageManagerFactory(
            config.GetUnistat()
            , config.GetYtObjectStorage()
            , shardsFactory.GetShard(0)
        )
    };
}

class TStandaloneController: public NInfra::NController::TStandaloneController {
public:
    TStandaloneController(TStringBuf config)
        : NInfra::NController::TStandaloneController(
            NProtoConfig::ParseConfigFromJson<TConfig>(config).GetController()
            , CreateFactories(config)
        )
    {
    }
};

} // namespace NInfra::NDeployMonitoringController
