#pragma once

#include <util/generic/map.h>
#include <util/generic/vector.h>
#include <util/system/mutex.h>

namespace NInfra::NDeployMonitoringController {

class THistogramUnistat {
private:
    Y_DECLARE_SINGLETON_FRIEND()

    THistogramUnistat() = default;

    THistogramUnistat(const THistogramUnistat&) = delete;
    THistogramUnistat& operator=(const THistogramUnistat&) = delete;

public:
    static THistogramUnistat& Instance() {
        return *Singleton<THistogramUnistat>();
    }

    // buckets must be strictly sorted
    // buckets[0] must be zero
    // buckets.size() <= MAX_BUCKETS_SIZE
    void AddOrUpdateHistogram(
        const TString& signal
        , const TVector<ui64>& values
        , const TVector<ui64>& buckets
    );

    void RemoveHistogram(
        const TString& signal
    );

    void RemoveAllHistograms();

    TString DumpHistograms() const;

private:
    // https://wiki.yandex-team.ru/golovan/userdocs/datatypes/?from=%252Fgolovan%252Fdatatypes%252F#usertypes
    static constexpr ui64 MAX_BUCKETS_SIZE = 50;

    // Store <x_i, number of values in bucket [x_i; x_{i + 1})>, buckets: [x_0; x_1), [x_1; x_2), [x_2; x_3) ... [x_n; inf)
    // TMap for stable output
    TMap<TString, TVector<std::pair<ui64, ui64>>> Signals_;
    TMutex Mutex_;
};

} // namespace NInfra::NDeployMonitoringController
