#include "unistat.h"

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NDeployMonitoringController::NUnistatTest {

Y_UNIT_TEST_SUITE(UnistatTestSuite) {

Y_UNIT_TEST(TestExceptions) {
    THistogramUnistat& unistat = THistogramUnistat::Instance();
    unistat.RemoveAllHistograms();

    UNIT_ASSERT_EXCEPTION_CONTAINS(
        unistat.AddOrUpdateHistogram(
            "signal"
            , {}
            , {}
        )
        , yexception
        , "At least one bucket must be provided"
    );

    {
        const size_t bucketsSize = 100;
        TVector<ui64> buckets;
        buckets.resize(bucketsSize);
        for (size_t i = 0; i < buckets.size(); ++i) {
            buckets[i] = i;
        }
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            unistat.AddOrUpdateHistogram(
                "signal"
                , {}
                , buckets
            )
            , yexception
            , "Buckets size can't be bigger then 50, actual size is 100"
        );
    }

    UNIT_ASSERT_EXCEPTION_CONTAINS(
        unistat.AddOrUpdateHistogram(
            "signal"
            , {}
            , {3, 4, 5}
        )
        , yexception
        , "First bucket must be zero, but actual value is 3"
    );

    UNIT_ASSERT_EXCEPTION_CONTAINS(
        unistat.AddOrUpdateHistogram(
            "signal"
            , {}
            , {0, 4, 5, 7, 6, 8}
        )
        , yexception
        , "Buckets must be strictly sorted, but buckets[3] = 7, buckets[4] = 6"
    );
}

Y_UNIT_TEST(TestDump) {
    THistogramUnistat& unistat = THistogramUnistat::Instance();
    unistat.RemoveAllHistograms();

    UNIT_ASSERT_EQUAL_C(
        unistat.DumpHistograms()
        , "[]"
        , unistat.DumpHistograms()
    );

    unistat.AddOrUpdateHistogram(
        "signal0"
        , {1, 0, 5, 100}
        , {0}
    );

    UNIT_ASSERT_EQUAL_C(
        unistat.DumpHistograms()
        , "[[\"signal0\",[[0,4]]]]"
        , unistat.DumpHistograms()
    );

    unistat.AddOrUpdateHistogram(
        "signal1"
        , {100, 1, 2, 3, 5, 6, 1, 2, 5, 8, 20, 21}
        , {0, 4, 6, 10, 20}
    );

    UNIT_ASSERT_EQUAL_C(
        unistat.DumpHistograms()
        , "[[\"signal0\",[[0,4]]],[\"signal1\",[[0,5],[4,2],[6,2],[10,0],[20,3]]]]"
        , unistat.DumpHistograms()
    );

    unistat.AddOrUpdateHistogram(
        "signal0"
        , {1, 0, 5, 100}
        , {0, 5}
    );

    UNIT_ASSERT_EQUAL_C(
        unistat.DumpHistograms()
        , "[[\"signal0\",[[0,2],[5,2]]],[\"signal1\",[[0,5],[4,2],[6,2],[10,0],[20,3]]]]"
        , unistat.DumpHistograms()
    );

    unistat.RemoveHistogram("signal1");

    UNIT_ASSERT_EQUAL_C(
        unistat.DumpHistograms()
        , "[[\"signal0\",[[0,2],[5,2]]]]"
        , unistat.DumpHistograms()
    );

    unistat.RemoveAllHistograms();

    UNIT_ASSERT_EQUAL_C(
        unistat.DumpHistograms()
        , "[]"
        , unistat.DumpHistograms()
    );
}

}

} // namespace NInfra::NDeployMonitoringController::NUnistatTest
