import datetime

from infra.deploy_notifications_controller.lib.models.user import User


class EventMeta:
    __slots__ = ['author', 'timestamp']

    author: User
    timestamp: int  # nanoseconds

    def __init__(
        self,
        author: str,
        timestamp: int
    ):
        self.author = User(author)
        self.timestamp = timestamp

    @property
    def str_time(self) -> str:
        return datetime.datetime.utcfromtimestamp(self.timestamp / 1e9).strftime('%Y-%m-%d %H:%M:%S.%f UTC')
