from infra.deploy_notifications_controller.lib.models.stage import Stage
from infra.deploy_notifications_controller.lib.models.user import User


class UrlFormatter:
    __slots__ = ['stage_controller', 'stage_format', 'user_format']

    stage_controller: str
    stage_format: str
    user_format: str

    def __init__(
        self,
        stage_format: str,
        user_format: str,
        stage_controller: str = '',
    ):
        self.stage_controller = stage_controller
        self.stage_format = stage_format
        self.user_format = user_format

    def stage_link(self, stage: Stage) -> str:
        return self.stage_format.format(controller=self.stage_controller, id=stage.id)

    def user_link(self, user: User) -> str:
        return self.user_format.format(name=user.name)

    link_methods = {
        Stage: stage_link,
        User: user_link,
    }

    def html_link(self, value) -> str:
        link = self.link_methods[value.__class__](value)
        return self.a_href(value, link)

    @staticmethod
    def a_href(value, link: str) -> str:
        # TODO escape value. Do we need jinja here? (it was for author name only)
        return f'<a href="{link}">{value}</a>'
