import functools
import itertools
from typing import Iterable, List, TypeVar, Type

import yt_yson_bindings


T = TypeVar('T')


def yson_to_proto(yson_response, proto_type: Type[T]) -> T:
    return yt_yson_bindings.loads_proto(yson_response.yson, proto_type, skip_unknown_fields=True)


def yson_to_proto_list(yson_response, proto_type: Type[T]) -> List[T]:
    raw = yt_yson_bindings.loads(yson_response.yson)
    if not raw or not isinstance(raw, list):
        return []

    return [
        yt_yson_bindings.loads_proto(yt_yson_bindings.dumps(item), proto_type, skip_unknown_fields=True)
        for item in raw
    ]


def chunk(chunk_size: int, iterable: Iterable[T]) -> List[T]:
    return list(itertools.islice(iterable, chunk_size))


def window(iterable: Iterable[T], chunk_size: int) -> Iterable[List[T]]:
    return iter(functools.partial(chunk, chunk_size, iter(iterable)), [])
