package ru.yandex.infra.sbr_updater;

import com.codahale.metrics.MetricRegistry;

import ru.yandex.qe.telemetry.metrics.Gauges;

public class Metrics {
    private static final String TOTAL_RESOURCES = "sbr.total_resources";
    private static final String DECAYED_RESOURCES = "sbr.decayed_resources";
    private static final String RESOLVED_RESOURCES = "sbr.resolved_resources";
    private static final String REFRESHED_RESOURCES = "sbr.refreshed_resourced";
    private static final String SANDBOX_ERRORS = "sbr.sandbox_errors";

    private int totalResources;
    private int decayedResources;
    private int resolvedResources;
    private int refreshedResources;
    private int sandboxErrors;


    public Metrics(MetricRegistry metricRegistry) {
        Gauges.forSupplier(metricRegistry, TOTAL_RESOURCES, this::getTotalResources);
        Gauges.forSupplier(metricRegistry, DECAYED_RESOURCES, this::getDecayedResources);
        Gauges.forSupplier(metricRegistry, RESOLVED_RESOURCES, this::getResolvedResources);
        Gauges.forSupplier(metricRegistry, REFRESHED_RESOURCES, this::getRefreshedResources);
        Gauges.forSupplier(metricRegistry, SANDBOX_ERRORS, this::getSandboxErrors);
    }


    public int getTotalResources() {
        return totalResources;
    }

    public void setTotalResources(int totalResources) {
        this.totalResources = totalResources;
    }

    public int getDecayedResources() {
        return decayedResources;
    }

    public void setDecayedResources(int decayedResources) {
        this.decayedResources = decayedResources;
    }

    public int getResolvedResources() {
        return resolvedResources;
    }

    public void setResolvedResources(int resolvedResources) {
        this.resolvedResources = resolvedResources;
    }

    public int getRefreshedResources() {
        return refreshedResources;
    }

    public void setRefreshedResources(int refreshedResources) {
        this.refreshedResources = refreshedResources;
    }

    public int getSandboxErrors() {
        return sandboxErrors;
    }

    public void setSandboxErrors(int sandboxErrors) {
        this.sandboxErrors = sandboxErrors;
    }

}
