package ru.yandex.infra.sbr_updater;

import java.util.Objects;

import com.google.common.base.MoreObjects;

import ru.yandex.yp.client.pods.TResourceMeta;

class Resource {
    private final String url;
    private final TResourceMeta meta;
    static final String SANDBOX_URL = "sbr:";
    static final String SANDBOX__HTTP_URL = "https://proxy.sandbox.yandex-team.ru/";

    public TResourceMeta getMeta() {
        return meta;
    }

    public String getUrl() {
        return url;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("url", url)
                .add("meta", meta)
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource) o;
        return Objects.equals(url, resource.url) &&
                Objects.equals(meta, resource.meta);
    }

    @Override
    public int hashCode() {
        return Objects.hash(url, meta);
    }

    public Resource(String url, TResourceMeta meta) {
        this.url = url;
        this.meta = meta;
    }

    public boolean hasInfiniteTTl() {
        if (meta == null || !meta.hasSandboxResource()) {
            return false;
        }
        String ttl = meta.getSandboxResource().getAttributesMap().get("ttl");
        return "inf".equals(ttl);
    }

    public String getSandboxId() {
        if (meta != null && meta.hasSandboxResource()) {
            return meta.getSandboxResource().getResourceId();
        }
        if (url.startsWith(SANDBOX_URL)) {
            return url.substring(SANDBOX_URL.length());
        }
        if (url.startsWith(SANDBOX__HTTP_URL)) {
            return url.substring(SANDBOX__HTTP_URL.length());
        }
        return null;
    }
}
