package ru.yandex.infra.sbr_updater;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SandboxOperations {
    private static final Logger LOG = LoggerFactory.getLogger(SandboxOperations.class);
    private final SandboxApi api;
    private final Metrics metrics;

    public SandboxOperations(SandboxApi api, Metrics metrics) {
        this.api = api;
        this.metrics = metrics;
    }

    public CompletableFuture<List<Long>> touchResourcesBatch(Set<Long> batch) {
        return api.batchResources(batch, "touch").thenApply(res -> {
                    List<Long> successfulTouchedResourceIds = res.stream()
                            .filter(r -> r.getStatus() == SandboxApi.BatchResults.StatusEnum.SUCCESS)
                            .map(SandboxApi.BatchResults::getId)
                            .collect(Collectors.toList());

                    List<Long> failedTouchedResourceIds = res.stream()
                            .filter(r -> r.getStatus() != SandboxApi.BatchResults.StatusEnum.SUCCESS)
                            .map(SandboxApi.BatchResults::getId)
                            .collect(Collectors.toList());

                    metrics.setRefreshedResources(successfulTouchedResourceIds.size());

                    LOG.info("successful touched resource ids: [{}]",
                            successfulTouchedResourceIds.stream().map(id -> id + "").collect(Collectors.joining(", ")));
                    LOG.info("failed touched resource ids: [{}]",
                            failedTouchedResourceIds.stream().map(id -> id + "").collect(Collectors.joining(", ")));

                    return failedTouchedResourceIds;
                }
        );
    }
}
