package ru.yandex.infra.sidecars_updater;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.infra.controller.dto.StageMeta;
import ru.yandex.infra.controller.yp.LabelBasedRepository;
import ru.yandex.infra.controller.yp.YpObject;
import ru.yandex.yp.client.api.TStageSpec;
import ru.yandex.yp.client.api.TStageStatus;

public class StageCache {
    private final LabelBasedRepository<StageMeta, TStageSpec, TStageStatus> stageRepo;
    private final AtomicReference<CompletableFuture<Map<String, YpObject<StageMeta, TStageSpec, TStageStatus>>>> stagesFutureCache;

    public StageCache(LabelBasedRepository<StageMeta, TStageSpec, TStageStatus> stageRepo) {
        this.stageRepo = stageRepo;
        this.stagesFutureCache = new AtomicReference<>(CompletableFuture.completedFuture(Map.of()));
    }

    /**
     * Refreshes {@link StageCache#stagesFutureCache} cache.
     * Selects current stages from YP.
     */
    @VisibleForTesting
    public void refreshStageCache() {
        stagesFutureCache.set(StageSelector.selectStagesList(stageRepo));
    }

    @VisibleForTesting
    public CompletableFuture<Map<String, YpObject<StageMeta, TStageSpec, TStageStatus>>> getStagesFutureCache() {
        return stagesFutureCache.get();
    }
}
