package ru.yandex.infra.sidecars_updater;

import java.util.Map;
import java.util.concurrent.CompletableFuture;

import one.util.streamex.EntryStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.bolts.collection.Try;
import ru.yandex.infra.controller.dto.StageMeta;
import ru.yandex.infra.controller.yp.LabelBasedRepository;
import ru.yandex.infra.controller.yp.SelectedObjects;
import ru.yandex.infra.controller.yp.Selector;
import ru.yandex.infra.controller.yp.YpObject;
import ru.yandex.yp.client.api.TStageSpec;
import ru.yandex.yp.client.api.TStageStatus;

import static java.util.Collections.emptyMap;

public class StageSelector {

    private static final Logger LOG = LoggerFactory.getLogger(StageSelector.class);

    public static CompletableFuture<Map<String, Try<YpObject<StageMeta, TStageSpec, TStageStatus>>>> selectAllStages(LabelBasedRepository<StageMeta,
            TStageSpec, TStageStatus> ypStageRepository) {
        return ypStageRepository.selectObjects(
                        new Selector.Builder()
                                .withLabels()
                                .withMeta()
                                .withSpecAndTimestamps()
                                .build(),
                        emptyMap())
                .thenApply(SelectedObjects::getObjects);
    }

    public static CompletableFuture<Map<String, YpObject<StageMeta, TStageSpec, TStageStatus>>> selectStagesList(LabelBasedRepository<StageMeta, TStageSpec,
            TStageStatus> ypStageRepository) {
        return selectAllStages(ypStageRepository)
                .thenApply(stages -> EntryStream.of(stages)
                        .filterValues(Try::isSuccess)
                        .mapValues(Try::get)
                        .toMap());
    }
}
