package ru.yandex.infra.sidecars_updater.metrics;

import java.util.concurrent.ConcurrentHashMap;

import com.codahale.metrics.MetricRegistry;

import ru.yandex.bolts.function.Function;
import ru.yandex.infra.sidecars_updater.sidecars.Sidecar;
import ru.yandex.qe.telemetry.metrics.Gauges;

public class Metrics {
    private final ConcurrentHashMap<Sidecar.Type, SidecarMetrics> sidecarMetrics = new ConcurrentHashMap<>();
    private final MetricRegistry metricRegistry;

    private Integer getMetric(Sidecar.Type type, Function<SidecarMetrics, Integer> accessor) {
        SidecarMetrics data = sidecarMetrics.get(type);
        if (data == null) {
            return 0;
        }
        return accessor.apply(data);
    }

    public void refreshMetrics(SidecarMetrics metrics) {
        Sidecar.Type type = metrics.getType();
        this.sidecarMetrics.put(type, metrics);
        metrics.getRevisionsToCount().forEach((revision, count) ->
                Gauges.forSupplier(metricRegistry, type + "." + revision,
                        () -> getMetric(type, m -> m.getCountByRevision(revision))
                )
        );
    }

    public Metrics(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;

        for (Sidecar.Type type : Sidecar.Type.values()) {
            Gauges.forSupplier(metricRegistry, type + ".latest", () -> getMetric(type, SidecarMetrics::getLatest));
            Gauges.forSupplier(metricRegistry, type + ".old", () -> getMetric(type, SidecarMetrics::getOld));
            Gauges.forSupplier(metricRegistry, type + ".to_update", () -> getMetric(type, SidecarMetrics::getToUpdate));
            Gauges.forSupplier(metricRegistry, type + ".unknown", () -> getMetric(type, SidecarMetrics::getUnknown));
        }
    }
}
