package ru.yandex.infra.sidecars_updater.metrics;

import java.util.HashMap;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

import ru.yandex.infra.sidecars_updater.sidecars.Sidecar;

public class SidecarMetrics {
    private int unknown = 0;
    private int latest = 0;
    private int old = 0;
    private int toUpdate = 0;
    private final Map<Long, Integer> revisionsToCount = new HashMap<>();
    private final Sidecar.Type type;

    public SidecarMetrics(Sidecar.Type type) {
        this.type = type;
    }

    public void incUnknown() {
        unknown++;
    }

    public void incLatest() {
        latest++;
    }

    public void incOld() {
        old++;
    }

    public void incToUpdate() {
        toUpdate++;
    }

    public int getUnknown() {
        return unknown;
    }

    public int getLatest() {
        return latest;
    }

    public int getOld() {
        return old;
    }

    public int getToUpdate() {
        return toUpdate;
    }

    public Map<Long, Integer> getRevisionsToCount() {
        return ImmutableMap.copyOf(revisionsToCount);
    }

    public int getCountByRevision(long revision) {
        return revisionsToCount.getOrDefault(revision, 0);
    }

    public void addRevision(long revision) {
        revisionsToCount.merge(revision, 1, Integer::sum);
    }

    public Sidecar.Type getType() {
        return type;
    }
}
