package ru.yandex.infra.sidecars_updater.metrics;

import java.util.List;

import ru.yandex.infra.sidecars_updater.DeployUnitSidecarInfo;
import ru.yandex.infra.sidecars_updater.sidecars.Sidecar;

public class SidecarMetricsService {
    private final Metrics metrics;

    public SidecarMetricsService(Metrics metrics) {
        this.metrics = metrics;
    }

    public void doUpdate(List<DeployUnitSidecarInfo> infos, Sidecar.Type type) {
        SidecarMetrics sidecarMetrics = new SidecarMetrics(type);
        infos.stream().filter(info -> info.getSidecarType().equals(type)).forEach(info -> {
            if (info.getCurrentRev().isEmpty() && info.getTargetRev().isEmpty()) {
                sidecarMetrics.incUnknown();
            } else if (info.getCurrentRev().isEmpty()) {
                sidecarMetrics.incToUpdate();
            } else if (info.getTargetRev().isEmpty()) {
                if (info.getCurrentRev().get() < info.getLatestSidecarRev()) {
                    sidecarMetrics.incOld();
                } else {
                    sidecarMetrics.incLatest();
                }
            } else if (info.getTargetRev().get() > info.getCurrentRev().get()) {
                sidecarMetrics.incToUpdate();
            }
            if (info.getCurrentRev().isPresent()) {
                sidecarMetrics.addRevision(info.getCurrentRev().get());
            }
        });

        metrics.refreshMetrics(sidecarMetrics);
    }
}
