package ru.yandex.infra.sidecars_updater.sandbox;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface SandboxClient {
    /**
     * Returns {@link CompletableFuture} of {@link List} of at most <code>limit</code>
     * <a href="https://sandbox.yandex-team.ru/resources">Sandbox</a> resources of given <code>type</code>
     * with READY sandbox state and descending order on revisions.
     * The order guarantees that the first element will be the latest one.
     *
     * @param type sandbox resource type
     * @param attributes attributes for request to sandbox
     * @param hidden sandbox request parameter
     * @param limit maximum size of resources
     * @return {@link CompletableFuture} of {@link List} of response resources
     */
    CompletableFuture<List<SandboxResourceInfo>> getResources(
            String type, Map<String, String> attributes, boolean hidden, long limit
    );
}
