package ru.yandex.infra.sidecars_updater.sandbox;

import java.util.Map;
import java.util.Optional;

public interface SandboxInfoGetter {
    /**
     * Returns <a href="https://sandbox.yandex-team.ru/resources">Sandbox</a> resource info with given url.
     *
     * @param url resource url
     * @return {@link Optional} with {@link SandboxResourceInfo}, if url was cached by
     * {@link SandboxInfoGetter#refreshTypeCache} method, or empty {@link Optional} otherwise.
     */
    Optional<SandboxResourceInfo> getSandboxResourceInfoByUrl(String url);

    /**
     * Collects caches about <a href="https://sandbox.yandex-team.ru/resources">Sandbox</a> resources of given type.
     *
     * @param type       sandbox resource type to collect cache about.
     * @param attributes sandbox attributes to request.
     * @param hidden     sandbox request parameter.
     */
    void refreshTypeCache(String type, Map<String, String> attributes, boolean hidden);
}
