package ru.yandex.infra.sidecars_updater.sandbox;

import java.util.List;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;

public class SandboxResourceInfo {
    private static final String SBR_URL_PREFIX = "sbr:";

    private final long revision;
    private final String type;
    private final String skynetId;
    private final String httpProxyUrl;
    private final List<String> httpUrls;

    public SandboxResourceInfo(
            long revision, String type, String skynetId, String httpProxyUrl, List<String> httpUrls
    ) {
        this.revision = revision;
        this.type = type;
        this.skynetId = skynetId;
        this.httpProxyUrl = httpProxyUrl;
        this.httpUrls = httpUrls;
    }

    public long getRevision() {
        return revision;
    }

    public String getType() {
        return type;
    }

    public String getSkynetId() {
        return skynetId;
    }

    public String getHttpProxyUrl() {
        return httpProxyUrl;
    }

    public List<String> getHttpUrls() {
        return httpUrls;
    }

    public String getSbrUrl() {
        return String.format("%s%d", SBR_URL_PREFIX, getRevision());
    }

    @VisibleForTesting
    public SandboxResourceInfo withRevision(long revision) {
        return new SandboxResourceInfo(
                revision,
                type,
                skynetId,
                httpProxyUrl,
                httpUrls
        );
    }

    @VisibleForTesting
    public SandboxResourceInfo withType(String type) {
        return new SandboxResourceInfo(
                revision,
                type,
                skynetId,
                httpProxyUrl,
                httpUrls
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("revision", revision)
                .add("type", type)
                .add("skynetId", skynetId)
                .add("httpProxyUrl", httpProxyUrl)
                .add("httpUrls", httpUrls)
                .toString();
    }
}
