package ru.yandex.infra.sidecars_updater.servlets;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.common.base.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.infra.controller.servlets.UnistatServlet;
import ru.yandex.infra.sidecars_updater.statistics.StatisticsRepository;

public class GroupStatServlet extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(UnistatServlet.class);
    private static final String STAT_NAME = "stat_name";

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOG.debug("/groupstat request from {}", req.getRemoteHost());
        resp.setContentType("application/json");
        String statName = req.getParameter(STAT_NAME);
        try (Writer writer = new OutputStreamWriter(resp.getOutputStream(), Charsets.ISO_8859_1)) {
            if (statName == null) {
                writer.write("{\"error\" : \"" + STAT_NAME + " parameter isn't provided\"}");
            } else if (!StatisticsRepository.statisticsGroupResults.containsKey(statName)) {
                writer.write("{\"error\" : \"no such group statistics\",\n");
                writer.write("\"available group stats\" : [");
                writer.write(StatisticsRepository.statisticsGroupResults.keySet().stream()
                        .map(name -> "\"" + name + "\"").collect(Collectors.joining(",")));
                writer.write("]}");
            } else {
                Map<Long, Set<String>> groups = StatisticsRepository.statisticsGroupResults.get(statName);
                writer.write("{\n");
                writer.write(
                        groups.entrySet().stream().map(entry -> {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("\"").append(entry.getKey()).append("\" : ");
                            stringBuilder.append("[");
                            stringBuilder.append(entry.getValue().stream()
                                    .map(name -> "\"" + name + "\"")
                                    .collect(Collectors.joining(", ")));
                            stringBuilder.append("]");
                            return stringBuilder;
                        }).collect(Collectors.joining(",\n"))
                );
                writer.write("}");
            }
        }
    }
}
