package ru.yandex.infra.sidecars_updater.sidecar_service;

import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.infra.sidecars_updater.StageUpdateNotifier;
import ru.yandex.infra.sidecars_updater.sidecars.Sidecar;
import ru.yandex.startrek.client.model.Issue;

public class SidecarsServiceProxy {


    public static final String STARTREK_ADDRESS = "https://st.yandex-team.ru";
    private static final Logger LOG = LoggerFactory.getLogger(SidecarsServiceProxy.class);
    private final StageUpdateNotifier stageUpdateNotifier;
    private final UpdateTaskRunner updateTaskRunner;

    private final YtUpdateTaskRepository ytUpdateTaskRepository;

    public SidecarsServiceProxy(SidecarsService sidecarsService,
                                StageUpdateNotifier stageUpdateNotifier,
                                UpdateTaskRunner updateTaskRunner, YtUpdateTaskRepository ytUpdateTaskRepository) {
        this.stageUpdateNotifier = stageUpdateNotifier;
        this.updateTaskRunner = updateTaskRunner;
        this.ytUpdateTaskRepository = ytUpdateTaskRepository;
        ytUpdateTaskRepository.selectAllRows(sidecarsService, stageUpdateNotifier).stream()
                .filter(task -> task.getStatus() == UpdateTask.Status.IN_PROGRESS)
                .forEach(updateTaskRunner::addTask);
    }

    public Pair<String, String> applyOnPercent(Optional<Sidecar> sidecar, OptionalInt patchersRevision, int percent,
                                               String initiator) {
        Optional<Issue> issue = stageUpdateNotifier.crateUpdateNotifyMultipleStages(sidecar, patchersRevision,
                percent, initiator);
//        if (issue.isEmpty()) {
//            throw new SidecarsServiceProxyError("Cannot create startrek issue");
//        }
        String id = issue.isPresent() ? issue.get().getId() : generateNewId();
        UpdateTask updateTask = new UpdateTask(id, sidecar, patchersRevision, percent, initiator, issue);
        updateTaskRunner.addTask(updateTask);
        ytUpdateTaskRepository.insertRows(List.of(updateTask));
        return Pair.of(updateTask.getId(),
                issue.map(value -> STARTREK_ADDRESS + "/" + value.getKey()).orElse("WITHOUT TICKET"));
    }

    private String generateNewId() {
        return UUID.randomUUID().toString();
    }

    public String getStatus(String id) {
        if (updateTaskRunner.getTask(id).isPresent()) {
            return updateTaskRunner.getTask(id).get().getStatus().name();
        } else {
            Optional<String> ans = ytUpdateTaskRepository.lookupRowStatus(id);
            if (ans.isEmpty()) {
                throw new SidecarsServiceProxyError("Invalid updateId");
            }
            return ans.get();
        }
    }

    @VisibleForTesting
    StageUpdateNotifier getStageUpdateNotifier() {
        return stageUpdateNotifier;
    }

    @VisibleForTesting
    public UpdateTaskRunner getUpdateTaskRunner() {
        return updateTaskRunner;
    }

    @VisibleForTesting
    public YtUpdateTaskRepository getYtUpdateTaskController() {
        return ytUpdateTaskRepository;
    }
}
