package ru.yandex.infra.sidecars_updater.sidecars;

import java.util.Map;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;

public abstract class AbstractSidecar implements Sidecar {
    protected long revision = 0;
    protected final Map<String, String> attributes;
    protected final Sidecar.Type type;
    protected final String label;

    public AbstractSidecar(Map<Sidecar.Type, Map<String, String>> sidecarsAttributes, Sidecar.Type type, String label) {
        this.attributes = ImmutableMap.copyOf(sidecarsAttributes.get(type));
        this.type = type;
        this.label = label;
    }

    @Override
    public long getRevision() {
        return revision;
    }

    @Override
    public void setRevision(long revision) {
        this.revision = revision;
    }

    @Override
    public Map<String, String> getAttributes() {
        return attributes;
    }

    @Override
    public Type getResourceType() {
        return type;
    }

    @Override
    public String getLabelName() {
        return label;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("type", getResourceType())
                .add("revision", revision)
                .toString();
    }
}
