package ru.yandex.infra.sidecars_updater.sidecars;

import java.util.Map;
import java.util.function.Function;

import ru.yandex.yp.client.api.TDeployUnitSpec;
import ru.yandex.yp.client.api.TSandboxResourceInfo;
import ru.yandex.yp.client.api.TStageSpec;

public class DRUSidecar extends ServiceSidecar {

    public DRUSidecar(Map<Sidecar.Type, Map<String, String>> sidecarsAttributes) {
        super(sidecarsAttributes, Type.DRU_LAYER, "druLayer");
    }

    @Override
    protected Function<TDeployUnitSpec, TSandboxResourceInfo> getSandboxResourceInfoGetter() {
        return TDeployUnitSpec::getDynamicResourceUpdaterSandboxInfo;
    }

    @Override
    public boolean isUsedBy(TStageSpec spec, String deployUnitName) {
        return spec.getDynamicResourcesMap().values().stream().anyMatch(dr -> dr.getDeployUnitRef().equals(deployUnitName));
    }
}
