package ru.yandex.infra.sidecars_updater.sidecars;

import java.util.Map;
import java.util.function.Function;

import ru.yandex.yp.client.api.TDeployUnitSpec;
import ru.yandex.yp.client.api.TSandboxResourceInfo;
import ru.yandex.yp.client.api.TStageSpec;

public class GdbSidecar extends ServiceSidecar {

    public GdbSidecar(Map<Type, Map<String, String>> sidecarsAttributes) {
        super(sidecarsAttributes, Type.INSTANCECTL_GDB_TOOLKIT, "gdb");
    }

    @Override
    protected Function<TDeployUnitSpec, TSandboxResourceInfo> getSandboxResourceInfoGetter() {
        return TDeployUnitSpec::getGdbLayerSandboxInfo;
    }

    @Override
    public boolean isUsedBy(TStageSpec spec, String deployUnitName) {
        if (!spec.containsDeployUnits(deployUnitName)) {
            return false;
        }
        TDeployUnitSpec du = spec.getDeployUnitsOrThrow(deployUnitName);
        return du.getCoredumpConfigCount() > 0;
    }
}
