package ru.yandex.infra.sidecars_updater.sidecars;

import java.util.Map;
import java.util.function.Function;

import ru.yandex.infra.sidecars_updater.util.Utils;
import ru.yandex.yp.client.api.TDeployUnitSpec;
import ru.yandex.yp.client.api.TSandboxResourceInfo;
import ru.yandex.yp.client.api.TStageSpec;

public class LogbrokerSidecar extends ServiceSidecar {

    public LogbrokerSidecar(Map<Sidecar.Type, Map<String, String>> sidecarsAttributes) {
        super(sidecarsAttributes, Type.LOGBROKER_TOOLS_PORTO_LAYER, "logbrokerToolsLayer");
    }

    @Override
    protected Function<TDeployUnitSpec, TSandboxResourceInfo> getSandboxResourceInfoGetter() {
        return TDeployUnitSpec::getLogbrokerToolsSandboxInfo;
    }

    @Override
    public boolean isUsedBy(TStageSpec spec, String deployUnitName) {
        if (!spec.containsDeployUnits(deployUnitName)) {
            return false;
        }
        TDeployUnitSpec du = spec.getDeployUnitsOrThrow(deployUnitName);
        return Utils.isDeployUnitUseLogs(du);
    }

}
