package ru.yandex.infra.sidecars_updater.sidecars;

import java.util.Map;
import java.util.function.Function;

import ru.yandex.yp.client.api.TDeployUnitSpec;
import ru.yandex.yp.client.api.TSandboxResourceInfo;
import ru.yandex.yp.client.api.TStageSpec;

public class PodAgentSidecar extends ServiceSidecar {

    public PodAgentSidecar(Map<Sidecar.Type, Map<String, String>> sidecarsAttributes) {
        super(sidecarsAttributes, Type.POD_AGENT_BINARY, "podBin");
    }

    @Override
    protected Function<TDeployUnitSpec, TSandboxResourceInfo> getSandboxResourceInfoGetter() {
        return TDeployUnitSpec::getPodAgentSandboxInfo;
    }

    @Override
    public boolean isUsedBy(TStageSpec spec, String deployUnitName) {
        return true;
    }
}
