package ru.yandex.infra.sidecars_updater.sidecars;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

import ru.yandex.yp.client.api.TDeployUnitSpec;
import ru.yandex.yp.client.api.TStageSpec;

public class RuntimeVersionSidecar extends AbstractSidecar {

    public RuntimeVersionSidecar(Map<Type, Map<String, String>> sidecarsAttributes) {
        super(sidecarsAttributes, Type.RUNTIME_VERSION, "RuntimeVersionLabel");
        this.revision = Long.parseLong(sidecarsAttributes.get(getResourceType()).get("last"));
    }

    @Override
    public void setRevision(long revision) {
    }

    @Override
    public long getRevision() {
        return revision;
    }

    @Override
    public Function<TDeployUnitSpec, Optional<Long>> getRevisionGetter() {
        return deployUnitSpec -> Optional.of((long) deployUnitSpec.getPatchersRevision());
    }

    @Override
    public boolean isUsedBy(TStageSpec spec, String deployUnitName) {
        return true;
    }

    @Override
    public boolean considerHidden() {
        return false;
    }
}
