package ru.yandex.infra.sidecars_updater.sidecars;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

import ru.yandex.yp.client.api.TDeployUnitSpec;
import ru.yandex.yp.client.api.TSandboxResourceInfo;

public abstract class ServiceSidecar extends AbstractSidecar {
    public ServiceSidecar(Map<Sidecar.Type, Map<String, String>> sidecarsAttributes, Sidecar.Type type, String label) {
        super(sidecarsAttributes, type, label);
    }

    @Override
    public Function<TDeployUnitSpec, Optional<Long>> getRevisionGetter() {
        return spec -> Optional.of(getSandboxResourceInfoGetter().apply(spec).getRevision());
    }

    protected abstract Function<TDeployUnitSpec, TSandboxResourceInfo> getSandboxResourceInfoGetter();

    @Override
    public boolean considerHidden() {
        return false;
    }
}
