package ru.yandex.infra.sidecars_updater.sidecars;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

import ru.yandex.yp.client.api.TDeployUnitSpec;
import ru.yandex.yp.client.api.TStageSpec;

public interface Sidecar {
    Function<TDeployUnitSpec, Optional<Long>> getRevisionGetter();

    boolean isUsedBy(TStageSpec spec, String deployUnitName);

    long getRevision();

    void setRevision(long revision);

    String getLabelName();

    Type getResourceType();

    Map<String, String> getAttributes();

    boolean considerHidden();

    enum Type {
        LOGBROKER_TOOLS_PORTO_LAYER,
        POD_AGENT_BINARY,
        PORTO_LAYER_DEPLOY_TVMTOOL,
        DRU_LAYER,
        PORTO_LAYER_SEARCH_UBUNTU_XENIAL_APP,
        PORTO_LAYER_SEARCH_UBUNTU_BIONIC_APP,
        PORTO_LAYER_SEARCH_UBUNTU_FOCAL_APP,
        INSTANCECTL_GDB_TOOLKIT,
        INSTANCECTL,
        RUNTIME_VERSION
    }
}
