package ru.yandex.infra.sidecars_updater.sidecars;

import java.util.Map;
import java.util.function.Function;

import ru.yandex.yp.client.api.TDeployUnitSpec;
import ru.yandex.yp.client.api.TSandboxResourceInfo;
import ru.yandex.yp.client.api.TStageSpec;

public class TVMSidecar extends ServiceSidecar {

    public TVMSidecar(Map<Sidecar.Type, Map<String, String>> sidecarsAttributes) {
        super(sidecarsAttributes, Type.PORTO_LAYER_DEPLOY_TVMTOOL, "tvm");
    }

    @Override
    protected Function<TDeployUnitSpec, TSandboxResourceInfo> getSandboxResourceInfoGetter() {
        return TDeployUnitSpec::getTvmSandboxInfo;
    }

    @Override
    public boolean isUsedBy(TStageSpec spec, String deployUnitName) {
        if (!spec.containsDeployUnits(deployUnitName)) {
            return false;
        }
        TDeployUnitSpec du = spec.getDeployUnitsOrThrow(deployUnitName);
        return du.hasTvmConfig();
    }
}
