package ru.yandex.infra.sidecars_updater.staff;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class IsDismissedResponse {
    private final List<Result> results;
    private final Integer total;

    IsDismissedResponse(@JsonProperty("result") List<Result> results, @JsonProperty("total") Integer total) {
        this.results = results;
        this.total = total;
    }

    public List<Result> getResults() {
        return results;
    }

    public Integer getTotal() {
        return total;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    static class Result {
        private final Official official;

        Result(@JsonProperty("official") Official official) {
            this.official = official;

        }

        public Official getOfficial() {
            return official;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    static class Official {
        private final Boolean isDismissed;

        Official(@JsonProperty("is_dismissed") Boolean isDismissed) {
            this.isDismissed = isDismissed;

        }

        public Boolean isDismissed() {
            return isDismissed;
        }
    }
}
