package ru.yandex.infra.sidecars_updater.statistics;

import java.util.Collection;
import java.util.Map;

import com.codahale.metrics.MetricRegistry;

import ru.yandex.bolts.function.Function;
import ru.yandex.infra.sidecars_updater.util.TStageAndDuId;
import ru.yandex.qe.telemetry.metrics.Gauges;

public class GlobalStatistics extends StaticStatistics<Integer> {
    private final Function<Collection<Integer>, Integer> globalMetric;

    public GlobalStatistics(String name,
                            Function<TStageAndDuId, Integer> deployUnitMetric,
                            Function<Collection<Integer>, Integer> stageMetric,
                            Function<Collection<Integer>, Integer> globalMetric,
                            StatisticsMode statisticsMode) {
        super(name, deployUnitMetric, stageMetric, statisticsMode);
        this.globalMetric = globalMetric;
    }

    @Override
    protected void doPrepare(MetricRegistry metricRegistry, String statisticName) {
        Gauges.forSupplier(metricRegistry, statisticName,
                () -> StatisticsRepository.statisticsResults.
                        getOrDefault(statisticName, 0));
    }

    @Override
    protected void doUpdate(MetricRegistry metricRegistry, String statName, Map<String, Integer> metricResults) {
        StatisticsRepository.statisticsResults.put(statName, globalMetric.apply(metricResults.values()));
    }
}
