package ru.yandex.infra.sidecars_updater.statistics;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import com.codahale.metrics.MetricRegistry;

import ru.yandex.bolts.function.Function;
import ru.yandex.infra.sidecars_updater.util.TStageAndDuId;

public class GroupStatistics<T extends Number> extends StaticStatistics<T> {
    public static final String STAT_PREFIX = "group_";

    public GroupStatistics(String name,
                           Function<TStageAndDuId, T> deployUnitMetric,
                           Function<Collection<T>, T> stageMetric,
                           StatisticsMode statisticsMode) {
        super(STAT_PREFIX + name, deployUnitMetric, stageMetric, statisticsMode);
    }
    @Override
    protected void doPrepare(MetricRegistry metricRegistry, String fullStatName) {
        StatisticsRepository.statisticsGroupResults.put(fullStatName, new ConcurrentHashMap<>());
    }

    @Override
    protected void doUpdate(MetricRegistry metricRegistry, String statName, Map<String, T> metricResults) {
        StatisticsRepository.statisticsGroupResults.get(statName).clear();
        Map<Long, Set<String>> groups = StatisticsRepository.statisticsGroupResults.get(statName);
        metricResults.forEach((objectName, metricRes) -> {
            long metricResLong = metricRes.longValue();
            if (!groups.containsKey(metricResLong)) {
                groups.put(metricResLong, new HashSet<>());
            }
            groups.get(metricResLong).add(objectName);
        });
    }
}
