package ru.yandex.infra.sidecars_updater.statistics;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

import com.codahale.metrics.MetricRegistry;

import ru.yandex.bolts.function.Function;
import ru.yandex.infra.sidecars_updater.util.TStageAndDuId;
import ru.yandex.qe.telemetry.metrics.yasm.YasmHistogram;

public class HistogramStatistics extends StaticStatistics<Integer> {
    private final Supplier<YasmHistogram> yasmHistogramSupplier;

    public HistogramStatistics(String name,
                               Function<TStageAndDuId, Integer> deployUnitMetric,
                               Function<Collection<Integer>, Integer> stageMetric,
                               Supplier<YasmHistogram> yasmHistogramSupplier,
                               StatisticsMode statisticsMode) {
        super(name, deployUnitMetric, stageMetric, statisticsMode);
        this.yasmHistogramSupplier = yasmHistogramSupplier;
    }
    @Override
    protected void doPrepare(MetricRegistry metricRegistry, String fullStatName) {}

    @Override
    protected void doUpdate(MetricRegistry metricRegistry, String statName, Map<String, Integer> statResults) {
        YasmHistogram yasmHistogram = yasmHistogramSupplier.get();
        statResults.values().forEach(yasmHistogram::update);
        metricRegistry.remove(statName);
        metricRegistry.register(statName, yasmHistogram);
    }
}
